<?php
if ( ! defined('ABSPATH') ) exit;

/* REGISTER SETTINGS GROUPS */
add_action('admin_init', function() {

    // Common
    register_setting('cmercury_common_group','cmercury_api_token');
    register_setting('cmercury_common_group','cmercury_api_token_status');
    register_setting('cmercury_common_group','cmercury_logging_enabled');

    // Forms
    register_setting('cmercury_contacts_group','cmercury_list_id');
    register_setting('cmercury_contacts_group','cmercury_forms_autointegrate');
    register_setting('cmercury_contacts_group','cmercury_cf7_email_field');
    register_setting('cmercury_contacts_group','cmercury_wpforms_email_field');
    register_setting('cmercury_contacts_group','cmercury_gravity_email_field');

    // Mailer
    register_setting('cmercury_trigger_group','cmercury_enable_mailer');
    register_setting('cmercury_trigger_group','cmercury_trigger_id');
    register_setting('cmercury_trigger_group','cmercury_sender_name');
    register_setting('cmercury_trigger_group','cmercury_from_email');
    register_setting('cmercury_trigger_group','cmercury_reply_to');
    register_setting('cmercury_trigger_group','cmercury_default_subject');
    register_setting('cmercury_trigger_group','cmercury_mailer_fallback');
    
	//WooCommerce
	//Registered in its own class file.
    
});

//api token check
function check_connection($apikey)
{
    $response = wp_remote_post(
        'https://api.cmercury.com/api/Account/CheckConnection',
        [
            'headers' => [
                'X-Token' => $apikey,
                'accept'  => 'application/json'
            ],
            'timeout' => 20
        ]
    );

    if (is_wp_error($response)) {
        return false;
    }

    $body = json_decode(wp_remote_retrieve_body($response), true);
    return isset($body['Valid']) && $body['Valid'] === true;
}


$apikey = get_option('cmercury_api_token', '');


if (!empty($apikey)) {
    $is_valid = check_connection($apikey);

    update_option(
        'cmercury_api_token_status',
        $is_valid ? 'valid' : 'invalid'
    );
}



/* RENDER SETTINGS PAGE */
function cmercury_render_settings_page() {

    if ( ! current_user_can('manage_options') ) return;

    $tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'authentication';
    ?>

    <div class="wrap">
<div class="cmercury-welcome-header">
    <h2>Welcome to cmercury for WordPress & WooCommerce</h2>
    
    <p>
        Connect your site to cmercury to unlock powerful marketing features and maximize your customer data:
    </p>

    <ol>
        <li><strong>WooCommerce Sync:</strong> Automatically sync all customers for advanced segmentation and personalized email marketing.</li>
        <li><strong>Email Deliverability:</strong> Route all transactional and system emails (newsletters, order confirmations, password resets, etc.) through the reliable cmercury Default Mailer. (Find this in the 'EMail Delivery' tab.)</li>
        <li><strong>Form Integration:</strong> Automatically add new subscribers from your shortcode forms and popular plugins like Contact Form 7, WPForms, and Gravity Forms.</li>
    </ol>

    <div style="margin-top: 20px; padding: 10px; border: 1px dashed #ccc; background: #f9f9f9;">
        <strong>Need Assistance?</strong> If you have any questions or need help with setup, please don't hesitate to reach out:
        <br>
        <span style="display: block; margin-top: 5px;">
            📧 Email us at <a href="mailto:support@cmercury.com">support@cmercury.com</a>.
        </span>
    </div>
</div>
<hr>
        <!-- TABS -->
        <h2 class="nav-tab-wrapper">
            <a class="nav-tab <?php echo $tab==='authentication' ? 'nav-tab-active' : ''; ?>" 
               href="?page=cmercury-settings&tab=authentication">Authentication</a>
            
            <a class="nav-tab <?php echo $tab==='contacts' ? 'nav-tab-active' : ''; ?>" 
               href="?page=cmercury-settings&tab=contacts">Forms Integration</a>

            <a class="nav-tab <?php echo $tab==='trigger' ? 'nav-tab-active' : ''; ?>" 
               href="?page=cmercury-settings&tab=trigger">Email Delivery (Default Mailer)</a>
			
			<a class="nav-tab <?php echo $tab==='woocommerce' ? 'nav-tab-active' : ''; ?>" 
			    href="?page=cmercury-settings&tab=woocommerce">WooCommerce Sync</a>

        </h2>


 <!-- AUTHENTICATION SETTINGS -->
        <?php if ( $tab === 'authentication' ) : ?>
                <form method="post" action="options.php">
            <?php settings_fields('cmercury_common_group'); ?>
            
            <h3>🔑 cmercury API Authentication</h3>

<p class="description">
    This section is required to connect your WordPress site to your cmercury account. Without a valid API Key, the plugin cannot sync customers, send transactional emails, or process form submissions.
</p>
            <table class="form-table">
                <tr>
                    <th>API Key</th>
                    <td>
                        <input type="password" 
                            name="cmercury_api_token" 
                            value="<?php echo esc_attr(get_option('cmercury_api_token','')); ?>" 
                            class="regular-text" />
                            <p class='description'>Enter the API Key obtained from the 'API Key' tab in your cmercury 'Account Settings'.
                            <br>👉 <strong>Don’t have an API Key yet?</strong> <a href="https://help.cmercury.com/docs/api-key-management/" target="_new">How to create a cmercury API Key?</a></p>
                    </td>
                </tr>
                
                 
                 <?php
                $apikeystatus = get_option('cmercury_api_token_status', '');
                 
                 if (!empty($apikeystatus)) { ?>
                    <tr>
                    <th>API Key Status</th>
                    <td>
                        <?php
                       
            if ($apikeystatus == 'valid') {
                echo '<span style="color:green;font-weight:bold;">✔ API token verified successfully.</span>';
            } elseif ($apikeystatus == 'invalid') {
                echo '<span style="color:red;font-weight:bold;">✘ Invalid API token. Please check and try again.</span>';
            }
            else {
                echo "api key status: ".$apikeystatus."";
            }
            ?>
                    </td>
                </tr>
                 <?php } ?>
              
                
                
                <tr>
                    <th>Enable Logging</th>
                    <td>
                        <label>
                            <input type="checkbox"
                                name="cmercury_logging_enabled"
                                value="yes"
                                <?php checked('yes', get_option('cmercury_logging_enabled','no')); ?> />
                            <p class="description">Logs will be saved to: <code>/wp-content/uploads/cmercury-wordpress-plugin-yyyymmdd.log</code>
                                    (Recommended to enable only when identifying issues.)
            </p>
                        </label>
                    </td>
                </tr>
            </table>

            <?php submit_button('Save Authentication Settings'); ?>
        </form>
        
 <?php endif; ?>

        <!-- CONTACT SETTINGS -->
        <?php if ( $tab === 'contacts' ) : ?>
        <form method="post" action="options.php">
            <?php settings_fields('cmercury_contacts_group'); ?>

              <h2>➕ Forms Integration with cmercury</h2>
            <p class="description">
    Integrate cmercury with your subscription forms to automatically sync new email submissions to your audience list. This tab supports both a simple built-in shortcode form and popular third-party form plugins.
</p>
            <table class="form-table">
                <tr>
                    <th>Default Audience List ID</th>
                    <td>
                        <input type="text" name="cmercury_list_id"
                            value="<?php echo esc_attr(get_option('cmercury_list_id','')); ?>"
                            class="regular-text" />
                            <p class="description">
                Enter the cmercury List ID where new contacts will be added by default. This ID will be used for all integrations unless you explicitly override it via a shortcode parameter.
            </p>
                    </td>
                    
                    
                </tr>
                </table>
                <hr>

<h3>Third-Party Form Auto-Integration</h3>

<p class="description">
    Optionally enable automatic syncing for submissions made through these popular WordPress form plugins. <br>To ensure accurate mapping, enter the name of the 'Email Field' used in your forms. Leave blank to let the plugin attempt auto-detection
</p>

<table class="form-table">

                <tr>
        <th>Enable Auto-Integration</th>
        <td>
            <label>
                <input type="checkbox" name="cmercury_forms_autointegrate" value="yes" <?php checked('yes', get_option('cmercury_forms_autointegrate','no')); ?>/>
                Automatically integrate with Contact Form 7, WPForms, and Gravity Forms. 
            </label>
        </td>
    </tr>
                <tr>
                    <th>Contact Form 7: Email Field (Optional)</th>
                    <td>
                        <input type="text" name="cmercury_cf7_email_field"
                            value="<?php echo esc_attr(get_option('cmercury_cf7_email_field','')); ?>"
                            class="regular-text" />
                             <p class='description'>Enter the name of the email field. Leave blank to auto-detect.</p>
                    </td>
                </tr>

                <tr>
                    <th>WPForms: Email Field (Optional)</th>
                    <td>
                        <input type="text" name="cmercury_wpforms_email_field"
                            value="<?php echo esc_attr(get_option('cmercury_wpforms_email_field','')); ?>"
                            class="regular-text" /> 
                            <p class='description'>Enter the name of the email field. Leave blank to auto-detect.</p>
                    </td>
                </tr>

                <tr>
                    <th>Gravity Forms: Email Field (Optional)</th>
                    <td>
                        <input type="text" name="cmercury_gravity_email_field"
                            value="<?php echo esc_attr(get_option('cmercury_gravity_email_field','')); ?>"
                            class="regular-text" /> 
                            <p class='description'>Enter the name of the email field. Leave blank to auto-detect.</p>
                    </td>
                </tr>
                </table>
                            <?php submit_button('Save Form Settings'); ?>
        </form>

<hr>
<h3>Built-in Shortcode Form</h3>
<p class="description">
    For a simple, custom subscription form, use the shortcode below on any post, page, or widget:
</p>
<table class="form-table">
    <tr>
        <th>Basic Shortcode</th>
        <td>
            <code>[cmercury_form]</code>
            <p class="description">Uses the '**'Default Audience List ID'**' configured above.</p>
        </td>
    </tr>
    <tr>
        <th>Customization Examples</th>
        <td>
            <p><strong>Override List ID:</strong></p>
            <code>[cmercury_form list_id="<span style="color:red;">your-custom-id</span>" ]</code>
            
            <p><strong>Custom Button Text:</strong></p>
            <code>[cmercury_form button="<span style="color:red;">Join Our Newsletter</span>"]</code>
        </td>
    </tr>
</table>



        <?php endif; ?>


        <!-- MAILER SETTINGS -->
        <?php if ( $tab === 'trigger' ) : ?>
        <form method="post" action="options.php">
            <?php settings_fields('cmercury_trigger_group'); ?>

            <h2>📩 Email Delivery Settings (Use cmercury as Default Mailer)</h2>
<p class="description">
    This feature routes all outgoing WordPress and WooCommerce emails (such as newsletters, order confirmations, sign-up emails, password resets, etc.) through the cmercury Transactional Email service instead of your web host. This often improves deliverability and tracking.
</p>

<div style="padding:10px; background:#cbf5e8; border-left:4px solid #ff8000; margin: 10px 0;">
    <h3>⚠️ Mandatory Pre-Configuration Step</h3>
    <p>
        Before enabling these settings, you <strong>MUST</strong> configure a transactional campaign in your cmercury account:
    </p>
    <ol>
        <li>Go to your cmercury dashboard: <strong>Campaigns > Create Campaign > Automations > Transactional.</strong></li>
        <li>Create the transactional campaign and note down the unique <code>Trigger Id</code> generated by cmercury. You will enter this ID below.</li>
        
    </ol>
</div>
            <table class="form-table">
                <tr>
                    <th>Enable cmercury Email Delivery</th>
                    <td>
                        <label>
                            <input type="checkbox" 
                                name="cmercury_enable_mailer"
                                value="yes"
                                <?php checked('yes', get_option('cmercury_enable_mailer','no')); ?> />
                            Route all website emails through cmercury
                        </label>
                    </td>
                </tr>

                <tr>
                    <th>Trigger ID</th>
                    <td>
                        <input type="text" name="cmercury_trigger_id"
                            value="<?php echo esc_attr(get_option('cmercury_trigger_id','')); ?>"
                            class="regular-text" />
                            <p>Enter the Trigger ID of the transactional campaign created in cmercury.</p>
                    </td>
                </tr>

                <tr>
                    <th>Sender Name</th>
                    <td>
                        <input type="text" name="cmercury_sender_name"
                            value="<?php echo esc_attr(get_option('cmercury_sender_name','')); ?>"
                            class="regular-text" />
                            <p>Default sender name used for outgoing messages. Plugins may override this value when sending emails.</p>
                    </td>
                </tr>

                <tr>
                    <th>From Email</th>
                    <td>
                        <input type="email" name="cmercury_from_email"
                            value="<?php echo esc_attr(get_option('cmercury_from_email','')); ?>"
                            class="regular-text" />
                            <p>Default From Email address used for delivery. The domain in this email address must be configured and verified inside your cmercury account. eg. info@yourwebsite.com</p>
                    </td>
                </tr>

                <tr>
                    <th>Reply-To</th>
                    <td>
                        <input type="email" name="cmercury_reply_to"
                            value="<?php echo esc_attr(get_option('cmercury_reply_to','')); ?>"
                            class="regular-text" />
                            <p>This is the Default Reply-To Email Address.</p>
                    </td>
                </tr>

                <tr>
                    <th>Fallback to native mail</th>
                    <td>
                        <label>
                            <input type="checkbox" 
                                name="cmercury_mailer_fallback"
                                value="yes"
                                <?php checked('yes', get_option('cmercury_mailer_fallback','yes')); ?> />
                            Allow WordPress/PHP mail to be used if the cmercury API request fails.
                        </label>
                    </td>
                </tr>
                
                <tr>
        <th>Compatibility Note</th>
        <td>
            <p class="description" style="color:#147291;">
                If you use another SMTP or WP Mail plugin, you must set its mailer type to <strong>Default</strong> or <strong>PHP Mail</strong> to ensure cmercury successfully handles the delivery.
            </p>
        </td>
    </tr>
            </table>

            <?php submit_button('Save Email Delivery Settings'); ?>
        </form>

 <?php endif; ?>

<?php if ( $tab === 'woocommerce' ): ?>

    <?php if ( class_exists('WooCommerce') ): ?>

        <?php do_action('cmercury_render_wc_tab'); ?>

    <?php else: ?>

        <h2>WooCommerce Sync</h2>

        <p>
            The <strong>WooCommerce Sync</strong> feature allows you to automatically
            sync all your store customers to <strong>cmercury</strong>, keeping your marketing lists
            always fresh and ready for targeted campaigns.
        </p>

        <ul style="margin-left:20px;list-style:disc;">
            <li>Automatically push new customers into cmercury lists</li>
            <li>Send personalized email campaigns instantly using automations</li>
            <li>Keep customer profiles enriched and always updated</li>
        </ul>

        <p>
            This capability unlocks:
        </p>

        <ul style="margin-left:20px;list-style:disc;">
            <li>Better segmentation for marketing & automation</li>
            <li>More relevant follow-ups and offers</li>
            <li>Improved customer retention & lifetime value</li>
        </ul>

        <p><strong>To enable this feature, please install & activate WooCommerce.</strong></p>

        <p>
            Once activated, you’ll be able to seamlessly connect WooCommerce with cmercury
            for fully automated customer-list synchronization.
        </p>

    <?php endif; ?>

<?php endif; ?>

    </div>

<?php
}

