<?php
if ( ! defined('ABSPATH') ) exit;

class Cmercury_Hooks {

    public static function init() {
        add_shortcode('cmercury_form', [__CLASS__,'shortcode_form']);
        add_action('init', [__CLASS__,'maybe_process_shortcode'] );
        add_action('wp_loaded', [__CLASS__,'register_form_hooks'] );
    }

    public static function register_form_hooks() {
        $enabled = get_option('cmercury_forms_autointegrate','no');
        if ( $enabled !== 'yes' ) return;

        if ( defined('WPCF7_VERSION') ) {
            add_action('wpcf7_mail_sent', [__CLASS__,'cf7_mail_sent']);
        }
        if ( defined('WPFORMS_VERSION') || function_exists('wpforms') ) {
            add_action('wpforms_process_complete', [__CLASS__,'wpforms_process_complete'], 10, 4 );
        }
        if ( class_exists('GFAPI') ) {
            add_action('gform_after_submission', [__CLASS__,'gf_after_submission'], 10, 2 );
        }
    }

    public static function shortcode_form($atts) {
        $atts = shortcode_atts(array('list_id'=>get_option('cmercury_list_id',''),'button'=>'Subscribe','placeholder'=>'Email address'), $atts, 'cmercury_form');
        ob_start(); ?>
        <form class="cmercury-shortcode-form" method="post">
            <?php wp_nonce_field('cmercury_form_submit','cmercury_nonce'); ?>
            <input type="email" name="cmercury_email" placeholder="<?php echo esc_attr($atts['placeholder']); ?>" required>
            <input type="hidden" name="cmercury_list_id" value="<?php echo esc_attr($atts['list_id']); ?>">
            <button type="submit"><?php echo esc_html($atts['button']); ?></button>
        </form>
        <?php return ob_get_clean();
    }

    public static function maybe_process_shortcode() {
        if ( ! empty($_POST['cmercury_email']) ) {
            if ( ! isset($_POST['cmercury_nonce']) || ! wp_verify_nonce($_POST['cmercury_nonce'],'cmercury_form_submit') ) return;
            $email = sanitize_email($_POST['cmercury_email']);
            if ( ! is_email($email) ) return;
            $list = sanitize_text_field($_POST['cmercury_list_id'] ?? get_option('cmercury_list_id',''));
            $api = new Cmercury_Api();
            $meta = array('Source'=>'shortcode','Ip'=> $_SERVER['REMOTE_ADDR'] ?? '');
            $api->add_contact($list, $email, $meta);
            wp_safe_redirect( wp_get_referer() ? wp_get_referer() : home_url() );
            exit;
        }
    }

    private static function find_email_in_array($data, $mapping_field='') {
        if ( $mapping_field && isset($data[$mapping_field]) && is_email($data[$mapping_field]) ) return sanitize_email($data[$mapping_field]);
        foreach ( $data as $k => $v ) {
            if ( is_array($v) ) continue;
            $val = sanitize_text_field($v);
            if ( is_email($val) ) return $val;
        }
        return '';
    }

    public static function cf7_mail_sent($contact_form) {
        $submission = WPCF7_Submission::get_instance();
        if ( ! $submission ) return;
        $posted = $submission->get_posted_data();
        $map = get_option('cmercury_cf7_email_field','');
        $email = self::find_email_in_array($posted, $map);
        if ( empty($email) ) return;
        $list = get_option('cmercury_list_id','');
        $api = new Cmercury_Api();
        $api->add_contact($list, $email, array('Source'=>'cf7'));
    }

    public static function wpforms_process_complete($fields, $entry, $form_data, $entry_id) {
        $data = array();
        foreach ($fields as $f) {
            $name = isset($f['name']) ? $f['name'] : $f['id'];
            $data[$name] = isset($f['value']) ? $f['value'] : '';
        }
        $map = get_option('cmercury_wpforms_email_field','');
        $email = self::find_email_in_array($data, $map);
        if ( empty($email) ) return;
        $list = get_option('cmercury_list_id','');
        $api = new Cmercury_Api();
        $api->add_contact($list, $email, array('Source'=>'wpforms'));
    }

    public static function gf_after_submission($entry, $form) {
        $data = array();
        foreach ( $form['fields'] as $f ) {
            $val = rgar($entry, (string)$f->id);
            if ( ! empty($f->inputName) ) $data[$f->inputName] = $val;
            $data[$f->label] = $val;
        }
        $map = get_option('cmercury_gravity_email_field','');
        $email = self::find_email_in_array($data, $map);
        if ( empty($email) ) return;
        $list = get_option('cmercury_list_id','');
        $api = new Cmercury_Api();
        $api->add_contact($list, $email, array('Source'=>'gravityforms'));
    }
}
